/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.network;

import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.cluster.verification.ResultValuesUnavailableException;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.NoSuchNodeException;
import oracle.ops.mgmt.cluster.RemoteFileOperationException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.nodeapps.IPAddressException;
import oracle.ops.mgmt.nodeapps.IPAddressUtil;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.command.CheckTCPCommCommand;
import oracle.ops.verification.framework.command.RunTCPServerCommand;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.sTaskCheckIPMPSettings;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.network.ClusterNetworkInfo;
import oracle.ops.verification.framework.network.CommandHandler;
import oracle.ops.verification.framework.network.CommandHandlerFactory;
import oracle.ops.verification.framework.network.ConMatrix;
import oracle.ops.verification.framework.network.InterfaceInfo;
import oracle.ops.verification.framework.network.NetworkConstants;
import oracle.ops.verification.framework.network.NetworkException;
import oracle.ops.verification.framework.network.NodeInfo;
import oracle.ops.verification.framework.network.Subnet;
import oracle.ops.verification.framework.network.TCPMatrix;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.util.MultiNodeException;

public class VerifyNetwork
implements NetworkConstants {
    private static int DEFAULT_SSH_MAX_STARTUPS = 10;
    private static CommandHandler s_commandHandler = CommandHandlerFactory.createCommandHandler();
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private Socket serverSocket;

    public boolean checkReachFromLocalNode(String[] nodeList, boolean[] nodeConArray, String[] nodeErrorArray) throws NetworkException {
        boolean ret = false;
        ClusterCmd clusterCmd = new ClusterCmd();
        if (nodeConArray.length != nodeList.length) {
            Trace.out((String)"arrays' lengths don't match");
            throw new NetworkException(NetworkException.DEFAULT_MSG);
        }
        for (int i = 0; i < nodeList.length; ++i) {
            nodeConArray[i] = true;
        }
        try {
            int timeOut = 3;
            if (!new SystemFactory().CreateSystem().isUnixSystem()) {
                timeOut = 40;
            }
            Trace.out((String)("timeout = " + timeOut));
            ret = clusterCmd.areNodesAlive(nodeList, timeOut, null);
        }
        catch (ClusterException ce) {
            for (int i = 0; i < nodeList.length; ++i) {
                nodeConArray[i] = false;
            }
            Trace.out((Exception)((Object)ce));
            VerificationLogData.logError("CLUSTEREXCEPTION: " + ce.getMessage() + "\n" + Trace.getStackTrace((Throwable)ce));
            throw new NetworkException(NetworkException.FAILED_NODE_REACH_ALL, ce);
        }
        catch (RemoteFileOperationException re) {
            for (int i = 0; i < nodeList.length; ++i) {
                try {
                    int status = re.getStatus(nodeList[i]);
                    if (0 == status) {
                        nodeConArray[i] = true;
                        nodeErrorArray[i] = null;
                        Trace.out((String)(nodeList[i] + "is reachable from local node"));
                        continue;
                    }
                    nodeConArray[i] = false;
                    if (status == 1) {
                        nodeErrorArray[i] = re.getErrorMessage(nodeList[i]);
                    } else if (status == 2) {
                        nodeErrorArray[i] = re.getException(nodeList[i]).getMessage();
                    }
                    Trace.out((String)(nodeList[i] + " not reachable from local node"));
                    Trace.out((String)re.getErrorMessage(nodeList[i]));
                    VerificationLogData.logError("REMOTEFILEOPERATIONEXCEPTION: " + re.getMessage() + "\n" + Trace.getStackTrace((Throwable)re));
                    continue;
                }
                catch (NoSuchNodeException ne) {
                    VerificationLogData.logError("NOSUCHNODEEXCEPTION: " + ne.getMessage() + "\n" + Trace.getStackTrace((Throwable)ne));
                }
            }
        }
        return ret;
    }

    public boolean checkReachFromSrcNode(String[] nodeList, boolean[] nodeConArray, String srcNode) {
        int nodeCount;
        int numCmds = nodeCount = nodeList.length;
        for (int i = 0; i < nodeCount; ++i) {
            nodeConArray[i] = false;
        }
        VerificationCommand[] cmdArray = new VerificationCommand[numCmds];
        for (int i = 0; i < nodeCount; ++i) {
            cmdArray[i] = s_commandHandler.genReachCmd(srcNode, nodeList[i]);
        }
        ResultSet resultSet = new ResultSet();
        boolean cmdSucc = new GlobalHandler().submit((Command[])cmdArray, 0, resultSet, DEFAULT_SSH_MAX_STARTUPS);
        Trace.out((String)("cmdSucc=" + cmdSucc));
        for (int i = 0; i < nodeCount; ++i) {
            VerificationCommand vfyCmd = cmdArray[i];
            Result result = vfyCmd.getResult();
            if (result.getStatus() != 1) continue;
            nodeConArray[i] = s_commandHandler.parseConCmd(vfyCmd);
        }
        if (!cmdSucc) {
            return false;
        }
        int numConnected = 0;
        for (int i = 0; i < nodeCount; ++i) {
            if (!nodeConArray[i]) continue;
            ++numConnected;
        }
        return numConnected == nodeCount;
    }

    public boolean checkSubnetCon(List subnetList, List matrixList) throws NetworkException {
        ConMatrix matrix;
        boolean retVal = true;
        Vector<SubnetConThread> threadList = new Vector<SubnetConThread>();
        int numSubnets = subnetList.size();
        String subnetId = null;
        InterfaceInfo inf = null;
        for (Subnet subnet : subnetList) {
            int numInterfaces = subnet.getNumInterfaces();
            String[] tempIPList = new String[numInterfaces];
            String[] tempNodeList = new String[numInterfaces];
            String[] tempInterfaceList = new String[numInterfaces];
            subnetId = subnet.getSubnet();
            Trace.out((String)("\n Interfaces of subnet " + subnetId + ":"));
            Iterator ifIter = subnet.getInterfaces().iterator();
            int i = 0;
            while (ifIter.hasNext()) {
                inf = (InterfaceInfo)ifIter.next();
                Trace.out((Object)inf);
                tempIPList[i] = inf.getIP();
                tempNodeList[i] = inf.getNode();
                tempInterfaceList[i] = inf.getName();
                ++i;
            }
            Trace.out((String)"\n");
            matrix = new ConMatrix(subnetId, tempNodeList, tempIPList, tempInterfaceList);
            matrixList.add(matrixList.size(), matrix);
            threadList.add(new SubnetConThread(tempIPList, tempNodeList, subnetId, matrix));
        }
        Enumeration threadEnum = threadList.elements();
        while (threadEnum.hasMoreElements()) {
            Thread t = (Thread)threadEnum.nextElement();
            Trace.out((String)("==> Running " + t.getName()));
            t.start();
        }
        try {
            threadEnum = threadList.elements();
            while (threadEnum.hasMoreElements()) {
                ((Thread)threadEnum.nextElement()).join();
            }
        }
        catch (InterruptedException e) {
            VerificationLogData.logError("INTERRUPTEDEXCEPTION: " + e.getMessage() + "\n" + Trace.getStackTrace((Throwable)e));
            throw new NetworkException(e.getMessage(), e, true);
        }
        threadEnum = threadList.elements();
        while (threadEnum.hasMoreElements()) {
            matrix = ((SubnetConThread)threadEnum.nextElement()).getMatrix();
            boolean subnetCon = 1 == matrix.getStatus();
            if (subnetCon) continue;
            retVal = false;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("checkSubnetCon returns " + retVal));
        }
        return retVal;
    }

    public boolean checkSubnetTCPCon(List subnetList, List matrixList) throws NetworkException {
        TCPMatrix matrix;
        Vector<SubnetTCPThread> threadList = new Vector<SubnetTCPThread>();
        String subnetId = null;
        InterfaceInfo inf = null;
        boolean subnetTCPCon = false;
        boolean retVal = false;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        for (Subnet subnet : subnetList) {
            int numInterfaces = subnet.getNumInterfaces();
            String[] tempIPList = new String[numInterfaces];
            String[] tempNodeList = new String[numInterfaces];
            subnetId = subnet.getSubnet();
            Iterator ifIter = subnet.getInterfaces().iterator();
            int i = 0;
            while (ifIter.hasNext()) {
                inf = (InterfaceInfo)ifIter.next();
                tempIPList[i] = inf.getIP();
                tempNodeList[i] = inf.getNode();
                ++i;
            }
            matrix = new TCPMatrix(tempNodeList[0], tempIPList[0], tempNodeList, tempIPList);
            matrixList.add(matrixList.size(), matrix);
            threadList.add(new SubnetTCPThread(matrix));
        }
        Enumeration threadEnum = threadList.elements();
        while (threadEnum.hasMoreElements()) {
            Thread t = (Thread)threadEnum.nextElement();
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("==> Running " + t.getName()));
            }
            t.start();
        }
        try {
            threadEnum = threadList.elements();
            while (threadEnum.hasMoreElements()) {
                ((Thread)threadEnum.nextElement()).join();
            }
        }
        catch (InterruptedException e) {
            VerificationLogData.logError("INTERRUPTEDEXCEPTION: " + e.getMessage() + "\n" + Trace.getStackTrace((Throwable)e));
            throw new NetworkException(e.getMessage(), true);
        }
        threadEnum = threadList.elements();
        while (threadEnum.hasMoreElements()) {
            matrix = ((SubnetTCPThread)threadEnum.nextElement()).getMatrix();
            subnetTCPCon = 0 == matrix.getStatus();
            if (subnetTCPCon) continue;
            retVal = false;
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("checkSubnetTCPCon returning: " + retVal));
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"EXIT");
        }
        return retVal;
    }

    public boolean checkNodeConByIP(String[] IPList, String[] nodeList, ConMatrix matrix) {
        boolean allConnected = false;
        boolean[][] nodeConMatrix = matrix.getMatrixForChange();
        for (int i = 0; i < IPList.length; ++i) {
            for (int j = 0; j < IPList.length; ++j) {
                nodeConMatrix[i][j] = false;
            }
        }
        int numConnected = VerifyNetwork.getRowConByIP(0, IPList, nodeList, nodeConMatrix[0]);
        Trace.out((String)("\nIPList: '" + VerificationUtil.strArr2List(IPList) + "'\nnodeList: '" + VerificationUtil.strArr2List(nodeList) + "'\nnodeConMatrix: " + matrix.toString()));
        VerificationLogData.logInfo("\nIPList: '" + VerificationUtil.strArr2List(IPList) + "'\nnodeList: '" + VerificationUtil.strArr2List(nodeList) + "'\nnodeConMatrix: " + matrix.toString());
        if (numConnected == nodeList.length) {
            matrix.setStatus(1, true);
            allConnected = true;
            Trace.out((String)("Node " + nodeList[0] + "Connected to all."));
            Trace.out((String)("nodeConMatrix: " + nodeConMatrix));
        } else {
            matrix.setStatus(3, true);
            int numDisconnected = nodeList.length - numConnected;
            if (!nodeConMatrix[0][0]) {
                --numDisconnected;
            }
            Trace.out((String)("NumDisConnected: " + numDisconnected + " to Node " + nodeList[0]));
            if (numDisconnected > 1) {
                int i;
                IPConThread[] threadList = new IPConThread[numDisconnected];
                int[] disconToOriginalMap = new int[numDisconnected];
                String[] disconNodeList = new String[numDisconnected];
                String[] disconIPList = new String[numDisconnected];
                int disconIndex = 0;
                for (i = 1; i < nodeList.length; ++i) {
                    if (nodeConMatrix[0][i]) continue;
                    disconToOriginalMap[disconIndex] = i;
                    disconNodeList[disconIndex] = nodeList[i];
                    disconIPList[disconIndex] = IPList[i];
                    ++disconIndex;
                }
                for (int srcIndex = 0; srcIndex < numDisconnected; ++srcIndex) {
                    IPConThread t = new IPConThread(srcIndex, disconIPList, disconNodeList, new boolean[numDisconnected]);
                    t.setName("IPConThread_" + IPList[srcIndex]);
                    threadList[srcIndex] = t;
                }
                for (i = 0; i < numDisconnected; ++i) {
                    Trace.out((String)("Starting thread:" + threadList[i].getName()));
                    threadList[i].start();
                }
                for (i = 0; i < numDisconnected; ++i) {
                    try {
                        threadList[i].join();
                        continue;
                    }
                    catch (InterruptedException e) {
                        Trace.out((Object)e.getStackTrace());
                        VerificationLogData.logError("INTERRUPTEDEXCEPTION: " + e.getMessage() + "\n" + Trace.getStackTrace((Throwable)e));
                    }
                }
                for (i = 0; i < numDisconnected; ++i) {
                    boolean[] rowCon = threadList[i].getRowCon();
                    int srcInOriginal = disconToOriginalMap[i];
                    for (int j = 0; j < numDisconnected; ++j) {
                        int indexInOriginal = disconToOriginalMap[j];
                        nodeConMatrix[srcInOriginal][indexInOriginal] = rowCon[j];
                        Trace.out((String)(j + ">>Setting nodeConMatrix[" + srcInOriginal + "][" + indexInOriginal + "] =" + rowCon[j]));
                    }
                }
            }
        }
        Trace.out((String)("Exiting...\nIPList: '" + VerificationUtil.strArr2List(IPList) + "'\nnodeList: '" + VerificationUtil.strArr2List(nodeList) + "'\nnodeConMatrix: " + matrix.toString()));
        VerificationLogData.logInfo("\nExiting... IPList: '" + VerificationUtil.strArr2List(IPList) + "'\nnodeList: '" + VerificationUtil.strArr2List(nodeList) + "'\nnodeConMatrix: " + matrix.toString());
        return allConnected;
    }

    public int getInterfaceInfo(String[] nodeList, List<NodeInfo> nodeInfoList) throws NetworkException, MultiNodeException {
        int nodeCount = nodeList.length;
        int succNodeCount = 0;
        VerificationCommand[] cmdArray = new VerificationCommand[nodeCount];
        MultiNodeException mne = null;
        for (int j = 0; j < nodeCount; ++j) {
            cmdArray[j] = s_commandHandler.genGetIfInfoCmd(nodeList[j]);
        }
        ResultSet resultSet = new ResultSet();
        boolean cmdSucc = new GlobalHandler().submit((Command[])cmdArray, 0, resultSet);
        if (!resultSet.anySuccess()) {
            Trace.out((String)"GlobalHandler failed");
            throw new NetworkException(s_msgBundle.getMessage("4080", false));
        }
        for (int nodeIndex = 0; nodeIndex < nodeCount; ++nodeIndex) {
            VerificationCommand vfyCmd = cmdArray[nodeIndex];
            Result result = vfyCmd.getResult();
            if (result.getStatus() == 1) {
                NodeInfo nodeInfo = s_commandHandler.decodeIfInfo(vfyCmd);
                nodeInfoList.add(nodeInfo);
                ++succNodeCount;
                continue;
            }
            String errorMessage = null;
            String errorString = vfyCmd.getExceptionError();
            errorMessage = errorString != null && errorString.length() > 0 ? s_msgBundle.getMessage("6003", true, (Object[])new String[]{nodeList[nodeIndex]}) + s_msgBundle.getMessage("8504", false) + errorString : s_msgBundle.getMessage("6003", true, (Object[])new String[]{nodeList[nodeIndex]});
            NetworkException ne = new NetworkException(errorMessage);
            VerificationLogData.logError("No network interfaces found on node: " + nodeList[nodeIndex] + "\n" + errorMessage);
            if (null == mne) {
                mne = new MultiNodeException();
            }
            mne.addThrowable(nodeList[nodeIndex], ne);
        }
        if (null != mne) {
            throw mne;
        }
        return succNodeCount;
    }

    public int getInterfaceInfo(String[] nodeList, ClusterNetworkInfo cnInfo, List<NodeInfo> nodeInfoList) throws NetworkException, MultiNodeException {
        MultiNodeException mnEx = null;
        int sucNodes = 0;
        ArrayList<NodeInfo> tmpNodeInfoList = new ArrayList<NodeInfo>();
        try {
            sucNodes = this.getInterfaceInfo(nodeList, tmpNodeInfoList);
        }
        catch (MultiNodeException ex) {
            Trace.out((String)"MultiNodeException occured. ");
            mnEx = ex;
        }
        Trace.out((String)"Trying to resolve interface types");
        String[] subnets = cnInfo.getSubnets();
        int[] netTypes = cnInfo.getNetTypes();
        int i = 0;
        for (NodeInfo nodeInfo : tmpNodeInfoList) {
            NodeInfo newNodeInfo = null;
            for (Object objIfInfo : nodeInfo.getInterfaceList()) {
                InterfaceInfo ifInfo = (InterfaceInfo)objIfInfo;
                for (i = 0; i < subnets.length && !this.sameIPAddresses(subnets[i], ifInfo.getSubnet()); ++i) {
                }
                if (i == subnets.length) continue;
                if (newNodeInfo == null) {
                    newNodeInfo = new NodeInfo(nodeInfo.getName());
                }
                newNodeInfo.addInterface(new InterfaceInfo(ifInfo.getName(), ifInfo.getIP(), ifInfo.getSubnet(), ifInfo.getNetMask(), ifInfo.getType(), netTypes[i], ifInfo.getStatus(), ifInfo.getNode(), ifInfo.getDefGateway(), ifInfo.getGateway(), ifInfo.getHWAddr(), ifInfo.getMTU()));
            }
            if (newNodeInfo == null) continue;
            nodeInfoList.add(newNodeInfo);
        }
        if (mnEx != null) {
            throw mnEx;
        }
        return sucNodes;
    }

    public int getInterfaceInfo(String node, ClusterNetworkInfo cnInfo, List<InterfaceInfo> ifInfoList) throws NetworkException, MultiNodeException {
        ArrayList<NodeInfo> nodeInfoList = new ArrayList<NodeInfo>();
        String[] nodeList = new String[]{node};
        int sucNodes = this.getInterfaceInfo(nodeList, cnInfo, nodeInfoList);
        for (NodeInfo nodeInfo : nodeInfoList) {
            ifInfoList.addAll(nodeInfo.getInterfaceList());
        }
        return sucNodes;
    }

    private boolean sameIPAddresses(String ip1, String ip2) {
        boolean same = false;
        try {
            same = IPAddressUtil.sameIPAddresses((String)ip1, (String)ip2);
        }
        catch (IPAddressException ipEx) {
            Trace.out((String)("IPAddressException occured. mesg: " + ipEx.getMessage()));
        }
        return same;
    }

    public HashMap<String, List<sTaskCheckIPMPSettings.IPMPInterfaceInfo>> getIPMPConfigInfo(String[] nodeList, ResultSet ipmpRsltSet) {
        int nodeCount = nodeList.length;
        VerificationCommand[] cmdArray = new VerificationCommand[nodeCount];
        HashMap<String, List<sTaskCheckIPMPSettings.IPMPInterfaceInfo>> nodeWiseIPMPInfo = new HashMap<String, List<sTaskCheckIPMPSettings.IPMPInterfaceInfo>>();
        for (int j = 0; j < nodeCount; ++j) {
            cmdArray[j] = s_commandHandler.genGetIPMPInfoCmd(nodeList[j]);
        }
        new GlobalHandler().submit((Command[])cmdArray, 0, ipmpRsltSet);
        if (!ipmpRsltSet.anySuccess()) {
            Trace.out((String)"GlobalHandler failed");
            ipmpRsltSet.addErrorDescription(nodeList, new ErrorDescription(s_gMsgBundle.getMessage("1510", false)));
            return nodeWiseIPMPInfo;
        }
        for (int nodeIndex = 0; nodeIndex < nodeCount; ++nodeIndex) {
            VerificationCommand vfyCmd = cmdArray[nodeIndex];
            Result result = vfyCmd.getResult();
            String node = nodeList[nodeIndex];
            if (result.getStatus() == 1) {
                try {
                    nodeWiseIPMPInfo.put(vfyCmd.getNode(), s_commandHandler.decodeIPMPInfo(vfyCmd));
                }
                catch (NetworkException e) {
                    result.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("1511", true, (Object[])new String[]{node}) + VerificationConstants.LINE_SEPARATOR + e.getMessage()));
                    result.setStatus(3);
                    ipmpRsltSet.addResult(node, result);
                }
                continue;
            }
            result.addErrorDescription(new ErrorDescription(s_gMsgBundle.getMessage("1511", true, (Object[])new String[]{node})));
            ipmpRsltSet.addResult(node, result);
        }
        Trace.out((String)("Returning the IPMP Group as " + nodeWiseIPMPInfo));
        return nodeWiseIPMPInfo;
    }

    public boolean checkTCPComm(TCPMatrix matrix) {
        boolean clicmdResult = false;
        boolean srvcmdResult = false;
        String serverNode = matrix.getServerName();
        String serverIP = matrix.getServerIP();
        String[] clientList = matrix.getClientList();
        String[] IPList = matrix.getClientIPList();
        ResultSet resultSet = new ResultSet();
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("Check TCP communication for matrix: \n" + matrix.toString() + "\n"));
        }
        int nodeCount = clientList.length;
        int clicmdArraySize = 0;
        clicmdArraySize = nodeCount;
        for (String clientIP : IPList) {
            if (!serverIP.contentEquals(clientIP)) continue;
            --clicmdArraySize;
        }
        if (clicmdArraySize <= 0) {
            clicmdArraySize = 1;
        }
        Command[] clicmdArray = new Command[clicmdArraySize];
        Command[] startsrvcmdArray = new Command[1];
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("nodeCount: " + nodeCount + "\nClient command array size: " + clicmdArray.length));
        }
        startsrvcmdArray[0] = new RunTCPServerCommand(serverNode, serverIP);
        srvcmdResult = new GlobalHandler().submit(startsrvcmdArray, 0, resultSet);
        if (!srvcmdResult) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Exectask command to startup the server failed.");
            }
            return srvcmdResult;
        }
        VerificationCommand srvCommand = (VerificationCommand)startsrvcmdArray[0];
        RunTCPServerCommand runTCPsrv = (RunTCPServerCommand)startsrvcmdArray[0];
        Result srvResult = srvCommand.getResult();
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"Dumping result trace info.");
            srvResult.dumpTraceInfo();
            Trace.out((String)"End of dumping result trace info.");
        }
        String portPidStr = new String("-1");
        String portNumStr = new String("-1");
        String pidNumStr = new String("-1");
        try {
            portPidStr = srvResult.getActualValue();
            portNumStr = portPidStr.substring(0, portPidStr.indexOf(124));
            pidNumStr = portPidStr.substring(portPidStr.indexOf(124) + 1);
            matrix.setServerPID(pidNumStr);
            matrix.setServerPort(portNumStr);
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Port Number:" + portNumStr + "Process PID:" + pidNumStr));
            }
        }
        catch (ResultValuesUnavailableException rvue) {
            VerificationLogData.logError("RESULTVALUESUNAVAILABLEEXCEPTION: " + rvue.getMessage() + "\n" + Trace.getStackTrace((Throwable)rvue));
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)"ResultValuesUnavailable");
            }
        }
        catch (IndexOutOfBoundsException ioobe) {
            VerificationLogData.logError("INDEXOUTOFBOUNDSEXCEPTION: " + ioobe.getMessage() + "\n" + Trace.getStackTrace((Throwable)ioobe));
            Trace.out((String)("Cannot parse port number/process pid from: " + portPidStr));
        }
        int portNum = Integer.parseInt(portNumStr);
        if (portNum == -1) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Cannot identify port number string, aborting server");
            }
            this.terminateServer(matrix);
            return false;
        }
        int i = 0;
        int j = 0;
        while (i < nodeCount) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("\nTCP client command processing i:" + i + " j:" + j + "\n" + "server: " + serverNode + "(IP:" + serverIP + " PID:" + pidNumStr + ")" + " client: " + clientList[i] + "(" + IPList[i] + ")"));
            }
            if (serverIP.contentEquals(IPList[i]) && serverNode.compareToIgnoreCase(clientList[i]) == 0) {
                --j;
                matrix.setStatus(i, 0);
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("SKIPPING server: " + serverNode + "(" + serverIP + ")" + " client: " + clientList[i] + "(" + IPList[i] + ")"));
                }
            } else {
                clicmdArray[j] = new CheckTCPCommCommand(serverNode, serverIP, portNumStr, clientList[i], IPList[i]);
            }
            ++i;
            ++j;
        }
        if (j < 1) {
            this.terminateServer(matrix);
            return true;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("TCP communication submitting " + j + " commands.\n" + "Client command array size: " + clicmdArray.length));
        }
        try {
            clicmdResult = new GlobalHandler().submit(clicmdArray, 0, resultSet);
            this.terminateServer(matrix);
        }
        catch (Exception e) {
            VerificationLogData.logError("EXCEPTION: " + e.getMessage() + "\n" + Trace.getStackTrace((Throwable)e));
            Trace.out((String)("EXCEPTION: \n" + e.getMessage() + "\nTerminating server"));
            this.terminateServer(matrix);
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"TCP communication commands submitted.");
        }
        for (i = 0; i < clicmdArray.length; ++i) {
            VerificationCommand vfyCmd = (VerificationCommand)clicmdArray[i];
            CheckTCPCommCommand TCPcmd = (CheckTCPCommCommand)clicmdArray[i];
            Result result = vfyCmd.getResult();
            String clientVerified = TCPcmd.getClientIP();
            if (result.getStatus() != 1) continue;
            for (j = 0; j < clientList.length; ++j) {
                String retVal;
                block34: {
                    if (!IPList[j].contentEquals(clientVerified)) continue;
                    try {
                        if (Trace.isLevelEnabled((int)5)) {
                            Trace.out((String)("\nGetting status for: " + TCPcmd.getClientName() + ":" + TCPcmd.getClientIP()));
                        }
                        retVal = result.getActualValue();
                    }
                    catch (ResultValuesUnavailableException rvue) {
                        retVal = new String("-1");
                        if (!Trace.isLevelEnabled((int)5)) break block34;
                        Trace.out((String)("\nStatus unavailable for: " + TCPcmd.getClientName() + ":" + TCPcmd.getClientIP()));
                    }
                }
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("\nTCP status for " + TCPcmd.getClientName() + ":" + TCPcmd.getClientIP() + ":" + retVal));
                }
                if (retVal.contentEquals("0")) {
                    matrix.setStatus(j, 0);
                    continue;
                }
                if (!retVal.contentEquals("1")) continue;
                matrix.setStatus(j, 1);
            }
        }
        matrix.setStatus();
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("Setting matrix final status." + matrix.toString()));
        }
        VerificationLogData.logInfo("TCP MATRIX status: \n" + matrix.toString());
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"EXIT");
        }
        return clicmdResult && srvcmdResult && 1 == resultSet.getStatus();
    }

    private void terminateServer(TCPMatrix matrix) {
        GlobalExecution globalExec;
        InetAddress[] addrList = null;
        InetAddress serverAddr = null;
        PrintStream serverChannel = null;
        int i = 0;
        String serverIP = matrix.getServerIP();
        String serverPID = matrix.getServerPID();
        int portNum = Integer.parseInt(matrix.getServerPort());
        String localNode = null;
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\nAttempting to terminate TCP server: '" + serverIP + "' on port: '" + portNum + "' with process PID: '" + serverPID + "'"));
        }
        try {
            localNode = VerificationUtil.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            Trace.out((String)("UNKNOWNHOSTEXCEPTION: \n" + uhe));
            VerificationLogData.logError("UNKNOWNHOSTEXCEPTION: \n Not able to get the local hostname.");
            return;
        }
        if (!localNode.equals(matrix.getServerName())) {
            GlobalExecution globalExec2 = new GlobalExecution();
            if (!globalExec2.killProc(matrix.getServerName(), matrix.getServerPID())) {
                matrix.setServerExit(false);
                Trace.out((String)("Unable to kill server process: PID:'" + matrix.getServerPID() + "' IP:'" + matrix.getServerIP() + "' on Node: '" + matrix.getServerName() + "'"));
            }
            return;
        }
        try {
            serverAddr = InetAddress.getByName(serverIP);
        }
        catch (UnknownHostException uhe) {
            Trace.out((String)"UNKNOWNHOSTEXCEPTION: Cannot send terminate TCP server msg.");
            VerificationLogData.logError("UNKNOWNHOSTEXCEPTION: \nCannot send terminate TCP server msg.\n" + uhe.getMessage() + "\n" + Trace.getStackTrace((Throwable)uhe));
            return;
        }
        try {
            addrList = InetAddress.getAllByName(serverIP);
        }
        catch (UnknownHostException uhe) {
            Trace.out((String)"UNKNOWNHOSTEXCEPTION: Cannot send terminate TCP server msg.");
            VerificationLogData.logError("UNKNOWNHOSTEXCEPTION: \nCannot send terminate TCP server msg.\n" + uhe.getMessage() + "\n" + Trace.getStackTrace((Throwable)uhe));
            return;
        }
        for (InetAddress serverInterface : addrList) {
            if (serverInterface.toString().equalsIgnoreCase(serverAddr.toString())) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("\nSending terminate message to: " + serverInterface.toString() + " Port: " + portNum));
                }
                for (i = 0; i < 5; ++i) {
                    try {
                        this.serverSocket = new Socket(serverInterface, portNum);
                        break;
                    }
                    catch (IOException e) {
                        Trace.out((String)("IOEXCEPTION: Cannot create socket for connection to server." + e.getMessage()));
                        VerificationLogData.logError("IOEXCEPTION: \n" + e.getMessage() + "\n" + Trace.getStackTrace((Throwable)e));
                        if (i != 4) continue;
                        Trace.out((String)"FATAL ERROR: Cannot create socket, cannot send termination message to server.");
                        continue;
                    }
                }
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("\nSocket connected to remote port: " + this.serverSocket.getPort()));
                }
                for (i = 0; i < 5; ++i) {
                    try {
                        serverChannel = new PrintStream(this.serverSocket.getOutputStream(), true);
                        break;
                    }
                    catch (IOException e) {
                        Trace.out((String)("IOEXCEPTION: Cannot create print stream for connection to server." + e.getMessage()));
                        VerificationLogData.logError("IOEXCEPTION: \n" + e.getMessage() + "\n" + Trace.getStackTrace((Throwable)e));
                        if (i != 4) continue;
                        Trace.out((String)"FATAL ERROR: Cannot create print stream, cannot send termination message to server.");
                        return;
                    }
                }
                serverChannel.println("TerminateCVUTCPServer");
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    Trace.out((String)("IOEXCEPTION: Cannot send message to server." + e.getMessage()));
                    VerificationLogData.logError("IOEXCEPTION: \n" + e.getMessage() + "\n" + Trace.getStackTrace((Throwable)e));
                }
                continue;
            }
            if (!Trace.isLevelEnabled((int)5)) continue;
            Trace.out((String)("\nIP address: " + serverInterface.toString() + " does not match server IP of: " + serverIP));
        }
        if (!matrix.getServerPID().contentEquals("-1") && !(globalExec = new GlobalExecution()).killProc(matrix.getServerName(), matrix.getServerPID())) {
            matrix.setServerExit(false);
            Trace.out((String)("Unable to kill server process: PID:'" + matrix.getServerPID() + "' IP:'" + matrix.getServerIP() + "' on Node: '" + matrix.getServerName() + "'"));
        }
    }

    private static int getRowConByIP(int srcIndex, String[] IPList, String[] nodeList, boolean[] nodeConArray) {
        int nodeCount = IPList.length;
        int cmdCount = 0;
        int srcAddrType = 4;
        int destAddrType = 4;
        if (nodeCount > 0) {
            Trace.out((String)("Entered getRowConByIP src = " + nodeList[srcIndex] + ":" + IPList[srcIndex]));
        }
        for (int i = 0; i < nodeCount; ++i) {
            nodeConArray[i] = false;
        }
        VerificationCommand[] cmdArray = new VerificationCommand[nodeCount];
        if (IPAddressUtil.isIPv6AddressString((String)IPList[srcIndex])) {
            srcAddrType = 6;
        }
        for (int i = 0; i < nodeCount; ++i) {
            if (IPAddressUtil.isIPv6AddressString((String)IPList[i])) {
                destAddrType = 6;
            }
            Trace.out((String)("Address : " + IPList[srcIndex] + " " + "Type: " + srcAddrType));
            Trace.out((String)("Address : " + IPList[i] + " " + "Type: " + destAddrType));
            if (srcAddrType != destAddrType) continue;
            cmdArray[cmdCount++] = s_commandHandler.genIPConCmd(nodeList[srcIndex], IPList[srcIndex], IPList[i], srcAddrType);
        }
        ResultSet resultSet = new ResultSet();
        boolean cmdSucc = new GlobalHandler().submit((Command[])cmdArray, 0, resultSet, DEFAULT_SSH_MAX_STARTUPS);
        if (!cmdSucc) {
            Trace.out((String)"GlobalHandler.submit failed");
            return 0;
        }
        for (int nodeIndex = 0; nodeIndex < cmdCount; ++nodeIndex) {
            VerificationCommand vfyCmd = cmdArray[nodeIndex];
            Result result = vfyCmd.getResult();
            if (result.getStatus() != 1) continue;
            nodeConArray[nodeIndex] = s_commandHandler.parseConCmd(vfyCmd);
            Trace.out((String)(IPList[srcIndex] + "->" + IPList[nodeIndex] + ":" + nodeConArray[nodeIndex]));
        }
        int numConnected = 0;
        for (int i = 0; i < nodeCount; ++i) {
            if (!nodeConArray[i]) continue;
            ++numConnected;
        }
        Trace.out((String)("RowConByIP:: return = " + (numConnected == nodeCount)));
        return numConnected;
    }

    class SubnetTCPThread
    extends Thread {
        TCPMatrix m_matrix = null;

        SubnetTCPThread(TCPMatrix matrix) {
            this.m_matrix = matrix;
        }

        @Override
        public void run() {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("==> In run method of TCP comm. thread" + Thread.currentThread().getName()));
            }
            try {
                VerifyNetwork.this.checkTCPComm(this.m_matrix);
            }
            catch (Exception e) {
                Trace.out((String)("\nEXCEPTION: Cannot finish TCP connectivity check.\n" + e.getMessage() + "\n Check did not complete for: \n" + this.m_matrix.toString()));
            }
        }

        protected TCPMatrix getMatrix() {
            return this.m_matrix;
        }
    }

    class SubnetConThread
    extends Thread {
        String m_subnet;
        String[] m_IPList;
        String[] m_nodeList;
        ConMatrix m_matrix = null;

        SubnetConThread(String[] IPList, String[] nodeList, String subnet, ConMatrix matrix) {
            this.m_IPList = IPList;
            this.m_nodeList = nodeList;
            this.m_subnet = subnet;
            this.m_matrix = matrix;
            this.m_matrix.setIPList(IPList);
        }

        @Override
        public void run() {
            Trace.out((String)("==> In run method of thread" + Thread.currentThread().getName()));
            VerifyNetwork.this.checkNodeConByIP(this.m_IPList, this.m_nodeList, this.m_matrix);
        }

        protected ConMatrix getMatrix() {
            return this.m_matrix;
        }

        String getSubnet() {
            return this.m_subnet;
        }
    }

    class IPConThread
    extends Thread {
        int m_srcIndex = -1;
        String[] m_IPList = null;
        String[] m_nodeList = null;
        boolean[] m_nodeConArray = null;
        String m_errMsg;
        private boolean m_succ = false;

        protected IPConThread(int srcIndex, String[] IPList, String[] nodeList, boolean[] nodeConArray) {
            this.m_srcIndex = srcIndex;
            this.m_IPList = IPList;
            this.m_nodeList = nodeList;
            this.m_nodeConArray = nodeConArray;
            this.m_succ = false;
        }

        protected boolean getResult() {
            return this.m_succ;
        }

        protected boolean[] getRowCon() {
            return this.m_nodeConArray;
        }

        protected int getSrcIndex() {
            return this.m_srcIndex;
        }

        @Override
        public void run() {
            int numConnected = VerifyNetwork.getRowConByIP(this.m_srcIndex, this.m_IPList, this.m_nodeList, this.m_nodeConArray);
            this.m_succ = numConnected == this.m_nodeList.length;
            Trace.out((String)("==> Result of getRowConByIP " + this.m_succ));
        }
    }
}

